<?php
function get_all_vendors($conn) {
    $stmt = $conn->prepare("SELECT * FROM crashcourse.vendors");
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function get_vendor_by_id($conn, $vend_id) {
    $stmt = $conn->prepare("SELECT * FROM crashcourse.vendors WHERE vend_id = :vend_id");
    $stmt->bindParam(':vend_id', $vend_id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function update_vendor($conn, $vend_id, $vend_name, $vend_address, $vend_city, $vend_state, $vend_zip, $vend_country) {
    $stmt = $conn->prepare("UPDATE crashcourse.vendors 
        SET vend_name = :vend_name, vend_address = :vend_address, vend_city = :vend_city, 
            vend_state = :vend_state, vend_zip = :vend_zip, vend_country = :vend_country 
        WHERE vend_id = :vend_id");

    $stmt->bindParam(':vend_id', $vend_id, PDO::PARAM_INT);
    $stmt->bindParam(':vend_name', $vend_name);
    $stmt->bindParam(':vend_address', $vend_address);
    $stmt->bindParam(':vend_city', $vend_city);
    $stmt->bindParam(':vend_state', $vend_state);
    $stmt->bindParam(':vend_zip', $vend_zip);
    $stmt->bindParam(':vend_country', $vend_country);
    $stmt->execute();

    header("Location: vendor_details.php?id=" . $vend_id);
    exit();
}

function add_vendor($conn, $vend_id, $vend_name, $vend_address, $vend_city, $vend_state, $vend_zip, $vend_country) {
    $stmt = $conn->prepare("INSERT INTO crashcourse.vendors 
        (vend_name, vend_address, vend_city, vend_state, vend_zip, vend_country) 
        VALUES (:vend_name, :vend_address, :vend_city, :vend_state, :vend_zip, :vend_country)");

    $stmt->bindParam(':vend_name', $vend_name);
    $stmt->bindParam(':vend_address', $vend_address);
    $stmt->bindParam(':vend_city', $vend_city);
    $stmt->bindParam(':vend_state', $vend_state);
    $stmt->bindParam(':vend_zip', $vend_zip);
    $stmt->bindParam(':vend_country', $vend_country);
    $stmt->execute();

    header("Location: vendor_details.php?id=" . $vend_id);
    exit();
}

function update_products_vendor_to_null($conn, $vend_id) {
	$stmt = $conn->prepare("UPDATE products SET vend_id = NULL WHERE vend_id = :vend_id");
	$stmt->bindParam(':vend_id', $vend_id);
	$stmt->execute();
}

function delete_vendor($conn, $vend_id) {
	$stmt = $conn->prepare("DELETE FROM vendors Where vend_id = :vend_id");
	$stmt->bindParam(':vend_id', $vend_id);
	$stmt->execute();
}

function vendor_exists($conn, $vend_id) {
    try {
        $stmt = $conn->prepare("SELECT COUNT(*) FROM crashcourse.vendors WHERE vend_id = :vend_id");
        $stmt->bindParam(':vend_id', $vend_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchColumn() > 0;
    } catch (PDOException $e) {
        header("Location: ../view/error.php?message=" . urlencode("Vendor ID check failed."));
        exit;
    }
}

function get_products_by_vendor($conn, $vend_id) {
    $stmt = $conn->prepare("SELECT * FROM crashcourse.products WHERE vend_id = :vend_id");
    $stmt->bindParam(':vend_id', $vend_id, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>